#include "pch.h"
#include "../../lib/Shared/Internal.h"
#include "Utilities.h"

using namespace TwitchInGames;

void Utilities::WriteWarning(char const* message) {
#ifdef GTEST_OS_WINDOWS
	auto console= GetStdHandle(STD_OUTPUT_HANDLE);
	CONSOLE_SCREEN_BUFFER_INFO info;
	GetConsoleScreenBufferInfo(console, &info);
	SetConsoleTextAttribute(console, FOREGROUND_RED | FOREGROUND_GREEN | FOREGROUND_INTENSITY);
#endif
	std::cout << "WARNING: " << message << std::endl;
	DebugWriteLine(ToTstring(message).c_str());
#ifdef GTEST_OS_WINDOWS
	SetConsoleTextAttribute(console, info.wAttributes);
#endif
}
