#include "pch.h"
#include "../../lib/Shared/Internal.h"
#include "Utilities.h"
#ifndef GTEST_OS_WINDOWS
# include "Win32LibTest.h"
#endif

using namespace TwitchInGames;

TEST(Win32LibTest, CheckEmptyUserScienceEvent) {
	std::map<tstring, tstring> properties{
		{ _T("property1"), _T("value1") },
		{ _T("property2"), _T("value2") },
	};
	SendUserScienceEvent(Utilities::clientId, tstring(), _T("CheckEmptyUserScienceEvent"), properties);
}

TEST(Win32LibTest, CheckTokenScienceEvent) {
	std::map<tstring, tstring> properties{
		{ _T("property1"), _T("value1") },
		{ _T("property2"), _T("value2") },
	};
	SendTokenScienceEvent(Utilities::clientId, _T("token"), _T("CheckTokenScienceEvent"), properties);
}

TEST(Win32LibTest, CheckUserScienceEvent) {
	std::map<tstring, tstring> properties{
		{ _T("property1"), _T("value1") },
		{ _T("property2"), _T("value2") },
	};
	SendUserScienceEvent(Utilities::clientId, _T("user"), _T("CheckUserScienceEvent"), properties);
}

TEST(Win32LibTest, CheckKnownTwitchExceptionMessage) {
	TwitchException ex{ FromPlatformError(6) };
#ifdef __ORBIS__
	EXPECT_STREQ("Error -2147483642 (0x80000006)", ex.what());
#elif defined(_XBOX_ONE)
	EXPECT_STREQ("Error 6 (0x80070006)", ex.what());
#else
	EXPECT_STREQ("The handle is invalid.\r\n", ex.what());
#endif
}

TEST(Win32LibTest, CheckUnknownTwitchExceptionMessage) {
	TwitchException ex{ FromPlatformError(666) };
#ifdef __ORBIS__
	EXPECT_STREQ("Error -2147482982 (0x8000029a)", ex.what());
#else
	EXPECT_STREQ("Error 666 (0x8007029a)", ex.what());
#endif
}

TEST(Win32LibTest, CheckBase64Encode) {
	// https://en.wikipedia.org/wiki/Base64
	std::string message= "Man is distinguished, not only by his reason, but by "
		"this singular passion from other animals, which is a lust of the "
		"mind, that by a perseverance of delight in the continued and "
		"indefatigable generation of knowledge, exceeds the short vehemence "
		"of any carnal pleasure.";
	std::vector<char> data(message.cbegin(), message.cend());
	std::string actual= Base64Encode(data);
	std::string expected= "TWFuIGlzIGRpc3Rpbmd1aXNoZWQsIG5vdCBvbmx5IGJ5IGhpcyByZWFzb24sIGJ1dCBieSB0aGlzIHNpbmd1bGFyIHBhc3Npb24gZnJvbSBvdGhlciBhbmltYWxzLCB3aGljaCBpcyBhIGx1c3Qgb2YgdGhlIG1pbmQsIHRoYXQgYnkgYSBwZXJzZXZlcmFuY2Ugb2YgZGVsaWdodCBpbiB0aGUgY29udGludWVkIGFuZCBpbmRlZmF0aWdhYmxlIGdlbmVyYXRpb24gb2Yga25vd2xlZGdlLCBleGNlZWRzIHRoZSBzaG9ydCB2ZWhlbWVuY2Ugb2YgYW55IGNhcm5hbCBwbGVhc3VyZS4=";
	EXPECT_EQ(expected, actual);

	message= "any carnal pleasure";
	data.assign(message.cbegin(), message.cend());
	actual= Base64Encode(data);
	expected= "YW55IGNhcm5hbCBwbGVhc3VyZQ==";
	EXPECT_EQ(expected, actual);

	message= "any carnal pleasur";
	data.assign(message.cbegin(), message.cend());
	actual= Base64Encode(data);
	expected= "YW55IGNhcm5hbCBwbGVhc3Vy";
	EXPECT_EQ(expected, actual);

	message= "any carnal pleasu";
	data.assign(message.cbegin(), message.cend());
	actual= Base64Encode(data);
	expected= "YW55IGNhcm5hbCBwbGVhc3U=";
	EXPECT_EQ(expected, actual);

	message= "any carnal pleas";
	data.assign(message.cbegin(), message.cend());
	actual= Base64Encode(data);
	expected= "YW55IGNhcm5hbCBwbGVhcw==";
	EXPECT_EQ(expected, actual);

	message= "pleasure.";
	data.assign(message.cbegin(), message.cend());
	actual= Base64Encode(data);
	expected= "cGxlYXN1cmUu";
	EXPECT_EQ(expected, actual);

	message= "leasure.";
	data.assign(message.cbegin(), message.cend());
	actual= Base64Encode(data);
	expected= "bGVhc3VyZS4=";
	EXPECT_EQ(expected, actual);

	message= "easure.";
	data.assign(message.cbegin(), message.cend());
	actual= Base64Encode(data);
	expected= "ZWFzdXJlLg==";
	EXPECT_EQ(expected, actual);

	message= "asure.";
	data.assign(message.cbegin(), message.cend());
	actual= Base64Encode(data);
	expected= "YXN1cmUu";
	EXPECT_EQ(expected, actual);

	message= "sure.";
	data.assign(message.cbegin(), message.cend());
	actual= Base64Encode(data);
	expected= "c3VyZS4=";
	EXPECT_EQ(expected, actual);
}
