### Setup

1. Make sure you're using an internal repository. Either Artifactory (Twitch VPN required):
   ```
   echo "registry=https://npm.pkgs.xarth.tv/" > .npmrc
   ```
   or CodeArtifact (no VPN)
   ```
   echo "registry=https://amazon-149122183214.d.codeartifact.us-west-2.amazonaws.com/npm/shared/" > .npmrc
   ```

2. Install this plugin:

    ```
    # CodeArtifact version
    npm i @twitch/cdk-plugin-isengard

    # npm Artifactory
    npm i cdk-plugin-isengard
    
    # Yarn
    yarn add cdk-plugin-isengard
    ```

3. Add the plugin to your `cdk.json` file:

    ```js
    {
      // other settings...
      "plugin": ["cdk-plugin-isengard"]
    }
    ```
    
### How This Works

When CDK fetches credentials it uses the default providers from the JavaScript AWS SDK. This means that it
[first tries to use environment variables, and then looks for default credentials in ~/.aws/{config,credentials}](https://github.com/aws/aws-cdk/blob/6d762f97c9ed59d3182ae1688dec4bd015d8953d/packages/aws-cdk/lib/api/util/sdk.ts#L61-L65).

When credentials aren't available from the SDK, CDK passes the current stack's account ID to this plugin and gives it a chance to provide credentials. cdk-plugin-isengard calls Isengard to fetch temporary credentials for the stack account ID and the `Admin` (case-insensitive) role. If you need to use a different role, you can use the `ISENGARD_ROLE` environment variable to choose a different role:

```
ISENGARD_ROLE=Deployer npx cdk deploy MyStack
```

cdk-plugin-isengard uses the `mwinit` cookie to authenticate you. If your credentials have expired you'll be prompted to reauthenticate.

An alternative to this plugin is using the CDK `--profile` argument. This
argument can provide a profile that points to an AWS credentials entry using
`credential_process` to authenticate with Isengard. 

This plugin has two advantages over that approach:

1. The authentication is tied to the `env` configuration in your CDK code. You
_probably_ are including account numbers in CDK or at least have the concept of
deploying to different accounts (e.g. dev, prod) in your code. Using this plugin
means you don't need to match the --profile argument with the Stack `env` or
your stage.
2. This plugin provides an interactive prompt if you aren't authenticated with
`mwinit` and will save you from running a CDK command (need auth), running
mwinit, and then running that same CDK command again.

### Troubleshooting

> The security token included in the request is expired

Some credentials get used before CDK plugins have a chance to step in. If you
have credentials in environment variables or `~/.aws/{config,credentials}`
you may need to remove them.

Have you used `ada`? If so you may need to remove the default profile it
added to your `~/.aws/credentials` file. Did you paste Isengard credentials
as environment variables into your terminal? If so you may need to `unset`
those or open a new terminal session.

### Development

Run the unit tests with Jest.

```
npx jest
```

For manual integration testing run `npm link && tsc -w` to link and build
the project. Then run `npm link cdk-plugin-isengard` from a consuming
project.

To publish, increment the version number in package.json in a PR. When the
branch is merged to master it will publish the new version to Artifactory
and CodeArtifact.
