import { getMidwayVersionArgs } from "./authenticate-with-midway";

test('args for v1', () => {
  const args = getMidwayVersionArgs('mwinit version 1.22(ACME-test)');
  expect(args).toEqual([]);
});

test('args for later v1', () => {
  const args = getMidwayVersionArgs('mwinit version 1.24');
  expect(args).toEqual([]);
});

test('args for v2', () => {
  const args = getMidwayVersionArgs('mwinit version 2.2.1');
  expect(args).toEqual(['--aea']);
});

test('args for later v2', () => {
  const args = getMidwayVersionArgs('mwinit version 2.9.1');
  expect(args).toEqual(['--aea']);
});

test('args for way future version', () => {
  const args = getMidwayVersionArgs('mwinit version 80.0.0');

  // We'll keep quiet and hope this keeps working
  expect(args).toEqual(['--aea']);
});

test('unknown output', () => {
  const warnSpy = jest.spyOn(console, 'warn');
  const args = getMidwayVersionArgs('some crazy new output');
  expect(args).toEqual(['--aea']);
  expect(warnSpy).toHaveBeenCalledWith(expect.stringMatching(/unrecognized version/i));
});
