import { execSync, spawnSync } from "child_process";

export function authenticateWithMidway() {
  let versionOutput;
  try {
    versionOutput = execSync('mwinit --no-update-check --version').toString();
  } catch (e) {
    throw new Error([
      "Could not get your mwinit version by calling 'mwinit --version'. Do you have mwinit installed?",
      '',
      `exit-code: ${e.status}`,
      `message:   ${e.message}`,
      `stderr:    ${e.stderr}`,
      `stdout:    ${e.stdout}`,
    ].join('\n'));
  }

  const args = getMidwayVersionArgs(versionOutput);

  spawnSync('mwinit', args, { stdio: [process.stdin, process.stdout, process.stderr] });
}

export function getMidwayVersionArgs(versionOutput: string) {
  if (/version 1\./.test(versionOutput)) {
    return [];
  } else if (/version \d+\./.test(versionOutput)) {
    return ['--aea'];
  }

  console.warn(`Unrecognized version string from calling "mwinit --version": ${versionOutput}`);
  
  return ['--aea'];
}
