import { assertValidAccountID, assertValidRoleName, InvalidAccountIDError, InvalidRoleNameCharacters, RoleNameTooLong } from "./validation";

test('assertValidAccountID requires alphanumeric input', () => {
  // Should not throw.
  assertValidAccountID('123456789');

  try {
    assertValidAccountID('my-account-name');
    throw new Error("Expected call to throw");
  } catch(e) {
    expect(e).toBeInstanceOf(InvalidAccountIDError);
  }
});

test("assertValidRoleName requires role name matching AWS's documented constraints", () => {
  // Should not throw.
  assertValidRoleName('Admin');

  try {
    assertValidRoleName('!!!');
    throw new Error("Expected call to throw");
  } catch(e) {
    expect(e).toBeInstanceOf(InvalidRoleNameCharacters);
  }

  try {
    assertValidRoleName('aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaab');
    throw new Error("Expected call to throw");
  } catch(e) {
    expect(e).toBeInstanceOf(RoleNameTooLong);
  }
});
