export function assertValidAccountID(accountID: string): void {
  if (!/^[a-zA-Z0-9]+$/.test(accountID)) {
    throw new InvalidAccountIDError(accountID);
  }
}

export class InvalidAccountIDError extends Error {
  name = 'invalid-account-id';
  constructor(accountID: string) {
    super(`The account ID must match ^[a-zA-Z0-9]+$. ${accountID} should be the numeric ID of the AWS account and not the account Name.`);
  }
}

export function assertValidRoleName(roleName: string): void {
  if (!/[\w+=,.@-]+/.test(roleName)) {
    throw new InvalidRoleNameCharacters(roleName);
  }

  if (roleName.length > 64) {
    throw new RoleNameTooLong(roleName);
  }
}

export class InvalidRoleNameCharacters extends Error {
  name = 'invalid-role-name-characters';
  constructor(roleName: string) {
    super(`The role name must match /[\w+=,.@-]+/. You provided ${roleName}`);
  }
}

export class RoleNameTooLong extends Error {
  name = 'role-name-too-long';
  constructor(roleName: string) {
    super(`The role name cannot exceed 64 characters. You provided ${roleName}`);
  }
}
