#!/bin/bash
# This script is from: https://aws.amazon.com/blogs/compute/optimizing-disk-usage-on-amazon-ecs/
# It contains small modifications to handle output from newer versions of docker.

### Get docker free data and metadata space and push to CloudWatch metrics
###
### requirements:
###  * must be run from inside an EC2 instance
###  * docker with devicemapper backing storage
###  * aws-cli configured with instance-profile/user with the put-metric-data permissions
###  * local user with rights to run docker cli commands
###
### Created by Jay McConnell

# Collect region and instanceid from metadata
AWSREGION=`curl -ss http://169.254.169.254/latest/dynamic/instance-identity/document | jq -r .region`
AWSINSTANCEID=`curl -ss http://169.254.169.254/latest/meta-data/instance-id`

# https://stackoverflow.com/a/31625253
function dehumanize() {
  for v in "${!@:-$(</dev/stdin)}"
  do
    echo $v | awk \
      'BEGIN{IGNORECASE = 1}
       function printpower(n,b,p) {printf "%u\n", n*b^p; next}
       /[0-9]$/{print $1;next};
       /K(iB)?$/{printpower($1,  2, 10)};
       /M(iB)?$/{printpower($1,  2, 20)};
       /G(iB)?$/{printpower($1,  2, 30)};
       /T(iB)?$/{printpower($1,  2, 40)};
       /KB$/{    printpower($1, 10,  3)};
       /MB$/{    printpower($1, 10,  6)};
       /GB$/{    printpower($1, 10,  9)};
       /TB$/{    printpower($1, 10, 12)}'
  done
}

function getFreeSpace {
  df -ha | awk '/^overlay/ {print $4}' | tail -n 1
}

data=$(dehumanize `getFreeSpace`)
aws cloudwatch put-metric-data --value $data --namespace Flink --dimensions InstanceId=$AWSINSTANCEID --unit Bytes --metric-name free_disk_space --region $AWSREGION
aws cloudwatch put-metric-data --value $data --namespace Flink --unit Bytes --metric-name free_disk_space --region $AWSREGION
