import cdk = require('@aws-cdk/core');
import branchstacks = require('../lib/branch-stacks');

/*
For manual test, first add the oauth secret to SecretsManager.

Then run with:

    npx cdk deploy '*' -c branch=foo
*/

const app = new cdk.App();
const mitlloydEnv = { region: 'us-west-2', account: '036970336625' };

const repo = new branchstacks.Repo({
  name: 'chemtrail',
  owner: 'ce-analytics',
  auth: cdk.SecretValue.secretsManager('github', { jsonField: 'oauth' }),
});

const branchStacksInfra = new cdk.Stack(app, 'BranchStackInfra', { env: mitlloydEnv });
new branchstacks.Cleaner(branchStacksInfra, 'BranchStacksCleaner', {
  repo,
  adminPermissions: true,
});

const branchName = app.node.tryGetContext('branch');
if (!branchName) {
  throw new Error('Provide a branch in context');
} else {
  const currentBranch = repo.branch(branchName);
  const stackName = currentBranch.nameForStack('MyCleanableStack');
  const myStack = new cdk.Stack(app, stackName, { env: mitlloydEnv });
  currentBranch.tagAsDependent(myStack);
}

app.synth();
