import unittest

from tahoe import get_subscription_changes

class TestTahoe(unittest.TestCase):
    def test_get_subscription_changes(self):
        subs = ['spade.toadd', 'spade.existing']
        current_subs = [
            {'target': {'relation': 'toremove', 'schema': 'spade'}},
            {'target': {'relation': 'existing', 'schema': 'spade'}}
        ]
        to_rm, to_sub = get_subscription_changes(subs, current_subs)
        self.assertEqual([{'relation': 'toremove', 'schema': 'spade'}], to_rm)
        self.assertEqual([{'relation': 'toadd', 'schema': 'spade'}], to_sub)


if __name__ == '__main__':
    unittest.main()
