#!/usr/bin/env node
import * as dotenv from 'dotenv';
import 'source-map-support/register';
import { AccountStack } from './account-stack';
import { TahoeTapConsumerStack } from './tahoe-tap-consumer-stack';
import cdk = require('@aws-cdk/core');

dotenv.config()
const personalStack = process.env.PERSONAL_STACK;

const env = {
  region: "us-west-2",
  account: "986713075947", // kneafsey+Hack2020-TahoeTap@amazon.com
};

const app = new cdk.App();
const { vpc } = new AccountStack(app, 'Account', { env });

const name = personalStack
  ? `TahoeTapConsumer-${personalStack}`
  : 'TahoeTapConsumer';
new TahoeTapConsumerStack(app, name, { env, vpc });
