import * as ec2 from '@aws-cdk/aws-ec2';
import * as redshift from '@aws-cdk/aws-redshift';
import * as cdk from '@aws-cdk/core';
import * as tap from '../lib';

interface TahoeTapConsumerStackProps extends cdk.StackProps {
  vpc: ec2.IVpc;
}

export class TahoeTapConsumerStack extends cdk.Stack {
  constructor(scope: cdk.Construct, id: string, props: TahoeTapConsumerStackProps) {
    super(scope, id, props);
    const tapName = `tap-cdk-integration-${this.stackName}`.toLowerCase()

    const cluster = new redshift.Cluster(this, 'Tahoe', {
      vpc: props.vpc,
      clusterName: tapName,
      masterUser: {
        masterUsername: 'tahoe',
      },
    });
    cluster.connections.allowFrom(ec2.Peer.ipv4(props.vpc.vpcCidrBlock), ec2.Port.tcp(5439))

    new tap.Connection(this, 'Connection', {
      bindleId: 'amzn1.bindle.resource.ABCDEfghij1234567890',
      cluster,
      purpose: 'Integration tap for tahoe tap CDK library',
      tapName,
      views: ["spade.invariant_ping"],
      vpc: props.vpc,
      tahoeStage: tap.TahoeBeta,
    });
  }
}
