import { ValidatedProps, validateProps } from "../lib/registration";

test('validating string props', () => {
  // Doesn't throw with valid props
  validateProps(buildProps());
  // This used to fail with multiple calls to the same regexp
  validateProps(buildProps());

  expect(() => {
    validateProps(buildProps({
      bindleId: 'invalid!',
    }));
  }).toThrow();

  expect(() => {
    validateProps(buildProps({
      tapName: 'invalid!',
    }));
  }).toThrow();
});

function buildProps(overrides: Partial<ValidatedProps> = {}): ValidatedProps {
  return {
    tapName: "tap-name",
    bindleId: "amzn1.bindle.resource.ABCDEfghij1234567890",
    ...overrides,
  };
}
