# csv-to-events
Script that converts a formatted .csv file into Twitch events

## Setup
Create a .csv file that will contain all required information for the hydrated events.

The first entry of this .csv file must be a list of columns that must include:  
`Title`, `Description`, `Start Time`, `End Time`, `Timezone`, `Channel`, `Game`, `Parent Event`, `Event Image URL`, `Event ID`  
If you would like to modify a column name (say `Start At` instead of `Start Time`), make sure you update the appropriate global var in csv-to-events.go

Currently, Start Time and End Time parse times and timezones based on the layouts as described in a set of constants.  
If you would like to change this layout, make sure to understand how the [time.Parse](https://golang.org/pkg/time/#Parse) function works.

Channel is the login (name) of the user and maps to that user's id in the channelNameToIDMap.  
Game is the name of the game and maps to that game's id in the gameNameToIDMap.  
Parent Event is the name of the parent event and maps to that parent event's id in the eventNameToIDMap (this is also populated as the script runs, so be sure to create an event container before creating its leaves).  
Event Image URL is the URL of the event image and maps to that image's id in the eventImageToIDMap.

All of the aforementioned fields should eventually be automatically handled on a per-csv basis, but for now their values are hardcoded on csv-to-events.go .. change them as needed.

*If a required field does not exist (or is invalid) on a csv entry, the script will fail but record all events created up to the point of failure (see: "After running the script")*

## Run the script
To run the script, you will need to run the following command

`go run csv-to-events.go models.go -i [input filepath] -mode [dryrun/local/staging/production]`  
Both `-i` and `-mode` are required input flags.  
`-i` denotes the filepath of the .csv to-be-imported.  
`-mode` accepts dryrun, local, staging, or production as values and determines on which environment the script will be run. dryrun does not use the geaclient at all.

## After running the script
Regardless of whether the script is successful or fails (barring some very early or very late failures), the resulting .csv will appear in the `output` folder.  
The name of the .csv corresponding to the run of a script will be `[unix timestamp (s)]-[FAILED/SUCCESS]-output.csv`

## Event creation vs. Event update
If a .csv entry does not have a defined Event ID, that row will be hydrated into a new event (with the new Event ID stored in the output .csv)  
If a .csv entry has a defined Event ID, that row will be the contents of an update to the given event ID.