package pkgpath_test

import (
	"testing"

	"code.justin.tv/common/golibs/pkgpath"
)

func TestPkgpathMain(t *testing.T) {
	if pkgpath.GoTestAggressiveTrimpath {
		t.Skip("test package names are hidden in Go 1.10+")
	}
	pkg, ok := pkgpath.Main()
	if have, want := pkg, "code.justin.tv/common/golibs/pkgpath/_test"; have != want {
		t.Errorf("pkgpath.Main(); %q != %q", have, want)
	}
	if have, want := ok, true; have != want {
		t.Errorf("pkgpath.Main(); %t != %t", have, want)
	}
}
