# Gray's Events Almanac

A repository of all Events on Twitch from past, present, and [future](http://backtothefuture.wikia.com/wiki/Grays_Sports_Almanac).

## Development

Install homebrew, go, and docker

```sh
brew cask install docker
# Make sure to run Docker.app from your Applications folder afterwards
```

To start the server, run the following:

```sh
# Set up the database locally in a docker container
make db
migrate -source file://_db/migrations -database 'postgres://creatorbusiness@localhost/oracle?sslmode=disable' up

# Start the server
AWS_PROFILE=twitch-feed-dev make run
```

The vendor directory is managed by [dep](https://github.com/golang/dep).
You can install it via homebrew or ```go get``` To update, import your package and run:

```sh
dep ensure
dep prune
```

## Pubsub

Pubsub messages are pushed to the broker at http://pubsub-broker.internal.twitch.tv/v1/message

Currently available topics:

```json
Topic: "channel-event-updates.<channel_id>"

# EXAMPLE MESSAGES
# The channel is currently running a single event.
{
  "type": "live-event",
  "current_event": {
    "event_id": "XsMuLJb4RhOcRTkaDNSH9w",
    "type": "single",
    "title": "Zelda Charity",
    "parent": null
  },
  "timestamp": "2018-01-11T21:03:00Z",
}

# The channel is currently running a segment event.
{
  "type": "live-event",
  "current_event": {
    "event_id": "XsMuLJb4RhOcRTkaDNSH9w",
    "type": "segment",
    "title": "Dak and Jaxter",
    "parent": {
      "event_id": "DFSjkldfsjksdfjjkldfsj",
      "type": "timetable",
      "title": "AGDQ"
    }
  },
  "timestamp": "2018-01-11T21:03:00Z",
}

# There is no live event on this channel.
{
  "type": "live-event",
  "current_event": null,
  "timestamp": "2018-01-11T21:03:00Z",
}
```