# Dev DB Docker Image

Since we use RDS for our main DB, this lets you spin up a local postgres version.

## Image Usage
To use the dev DB image you simply need to run
```
docker run -d -p 5432:5432 docker.internal.justin.tv/twitch-events/oracle_db:latest
```

This will run postgres and init the DB to look like our staging environment.  If you want to load any specific migration you can load the tag that matches the migration.  For instance to load a DB snapshotted to migration `1500927117` simply change the tag to that migration.

```
docker run -d -p 5432:5432 docker.internal.justin.tv/twitch-events/oracle_db:1500927117
```

Once the image is running in the background you can connect via psql
```
psql -h localhost -p 5432 -U creatorbusiness oracle
```

## Updating the image

Create a DB dump with pg_dump
```
pg_dump -h $ORACLE_STAGING_DB -p 5432 -U creatorbusiness oracle > backup.sql
```

With the backup.sql in this directory rebuild the image and tag it with the matching migration
```
docker build -t docker.internal.justin.tv/twitch-events/oracle_db:$LATEST_MIGRATION .
docker push docker.internal.justin.tv/twitch-events/oracle_db:$LATEST_MIGRATION
```

Then tag it as latest
```
docker tag docker.internal.justin.tv/twitch-events/oracle_db:$LATEST_MIGRATION docker.internal.justin.tv/twitch-events/oracle_db:latest
docker push docker.internal.justin.tv/twitch-events/oracle_db:latest
```

### Caveats
When making the DB dump you might need to make some modifications.

#### Constraints
There are some CONSTRAINTS on tables that try to enforce dates to be in the future you should remove this constraints and readd them at the bottom of the file

#### rdsadmin
There are some permissions mutations for the role rdsadmin.  This role does not exist locally.  Just drop these permissions mutations
