-- The Visage v5 CreateEvent endpoint had a bug where it would pass the caller's user ID
-- as the event owner.  This resulted in cases where an event created by an editor on
-- behalf of another user, would be owned by the editor, instead of the other user.
-- This has been fixed in Visage, but our event_nodes table has data that needs to be fixed.

-- Right now, events are always broadcast on their owner's channels.  So we should be able
-- to fix the owner_ids by setting them to the corresponding channel_ids.

UPDATE event_nodes
SET owner_id = channel_id
WHERE channel_id IS NOT NULL;
