INSERT INTO event_nodes (
  id,
  owner_id,
  type,
  created_at,
  updated_at,
  deleted_at,
  start_time,
  end_time,
  cover_image_id,
  language,
  title,
  description,
  channel_id,
  game_id
) SELECT
 CAST(id AS varchar(64)),
 CAST(channel_id AS varchar(20)) AS owner,
 'single',
 created_at_utc,
 COALESCE(updated_at_utc, created_at_utc) AS updated_at,
 CASE WHEN status='available' THEN NULL
      ELSE updated_at_utc
 END AS deleted_at,
 start_time_utc,
 end_time_utc,
 CASE WHEN cover_image_uuid IS NOT NULL THEN 'oracle:' || channel_id || '/' || cover_image_uuid
      ELSE 'default:' || fallback_cover_image_uuid
 END as image_id,
 'legacy' AS language,
 title,
 COALESCE(description, '') AS description,
 CAST(channel_id AS varchar(20)) AS channel,
 CAST(game_id AS varchar(20)) AS game
FROM events;

INSERT INTO broadcasts (
  id,
  event_node_id,
  language,
  channel_id,
  game_id,
  start_time,
  end_time
) SELECT 
 id,
 id as event_id,
 language,
 channel_id,
 game_id,
 start_time,
 end_time
FROM event_nodes WHERE type='single';

INSERT INTO event_node_stats (
  event_node_id,
  follow_count
) SELECT
 CAST(event_id as varchar(64)),
 enabled_user_email_notification_count
FROM event_stats;
