CREATE TABLE IF NOT EXISTS events_history (
  operation             text            NOT NULL,
  effective_at          timestamp       DEFAULT current_timestamp NOT NULL,

  id                    bigint          NOT NULL,
  creator_id            integer         NOT NULL,
  start_time_utc        timestamp       NOT NULL,
  end_time_utc          timestamp       NOT NULL,
  time_zone_utc_offset  interval        NOT NULL,
  title                 varchar(255)    NOT NULL,
  game_id               integer         NOT NULL,
  description           text,
  status                events_status   NOT NULL,

  created_at            timestamp       NOT NULL,
  updated_at            timestamp,

  CONSTRAINT events_history_effective_at_after_now CHECK (effective_at >= current_timestamp)
);

CREATE INDEX events_history_id_idx ON events_history (id);


-- Protect the `events_history` table from modification:

REVOKE ALL PRIVILEGES ON TABLE events_history FROM PUBLIC;
GRANT SELECT ON TABLE events_history TO PUBLIC;


-- Function and trigger to record the state of an event record (from the
-- `events` table) after inserting, deleting, or updating the record:

CREATE FUNCTION insert_event_into_events_history()
RETURNS TRIGGER AS $$
BEGIN
  IF (TG_OP = 'INSERT') THEN
    INSERT INTO events_history VALUES(TG_OP, current_timestamp, NEW.*);
    RETURN NEW;
  ELSIF (TG_OP = 'DELETE') THEN
    INSERT INTO events_history VALUES(TG_OP, current_timestamp, OLD.*);
    RETURN OLD;
  ELSIF (TG_OP = 'UPDATE') THEN
    INSERT INTO events_history VALUES(TG_OP, current_timestamp, NEW.*);
    RETURN NEW;
  END IF;
  RETURN NULL;
END;
$$ LANGUAGE 'plpgsql';

CREATE TRIGGER events_after_insert_delete_update
AFTER INSERT OR DELETE OR UPDATE ON events
  FOR EACH ROW EXECUTE PROCEDURE insert_event_into_events_history();
