-- The `event_extensions` place where we want to store each
-- event extension that will increase flexibility for external teams.

CREATE TABLE IF NOT EXISTS event_extensions (
  event_id                                bigint          NOT NULL REFERENCES events (id),
  key                                     varchar(255)    NOT NULL,
  value                                   text
);

CREATE UNIQUE INDEX event_extensions_event_id_and_key_uniq_idx ON event_extensions (event_id, key);
CREATE INDEX event_extensions_event_id_idx ON event_extensions (event_id);
CREATE INDEX event_extensions_key_idx ON event_extensions (key);
