CREATE TYPE event_type AS ENUM ('single', 'premiere', 'segment', 'schedule');

CREATE TABLE IF NOT EXISTS event_nodes (
  id          varchar(64)     PRIMARY KEY,
  owner_id    varchar(20)     NOT NULL,
  type        event_type      NOT NULL,
  parent_id   varchar(64),

  created_at  timestamp       DEFAULT current_timestamp NOT NULL,
  updated_at  timestamp       NOT NULL,
  deleted_at  timestamp,

  start_time  timestamp,
  end_time    timestamp,

  cover_image_id  varchar(255),
  language        varchar(10),
  title           varchar(255),
  description     text,
  channel_id      varchar(20),
  game_id         varchar(20)
);

CREATE TABLE IF NOT EXISTS event_node_stats (
  event_node_id   varchar(64)  PRIMARY KEY,
  follow_count    int          DEFAULT 0 NOT NULL,
  hype            int          DEFAULT 0 NOT NULL
);

CREATE TABLE IF NOT EXISTS event_node_attributes (
  event_node_id   varchar(64)  NOT NULL,
  key             varchar(255) NOT NULL,
  value           text         NOT NULL,
  PRIMARY KEY (event_node_id, key)
);

CREATE INDEX key_value_idx ON event_node_attributes (key, value);

CREATE TABLE IF NOT EXISTS event_node_tags (
  event_node_id   varchar(64)   NOT NULL,
  tag_name        varchar(255)  NOT NULL,
  PRIMARY KEY (event_node_id, tag_name)
);

CREATE TABLE IF NOT EXISTS event_node_localizations (
  event_node_id   varchar(64) NOT NULL,
  language        varchar(10) NOT NULL,

  created_at      timestamp   default current_timestamp NOT NULL,
  updated_at      timestamp   NOT NULL,

  title           varchar(255),
  description     text,
  channel_id      varchar(20),
  PRIMARY KEY (event_node_id, language)
);

CREATE TABLE IF NOT EXISTS broadcasts (
  id            varchar(64)   PRIMARY KEY,
  event_node_id varchar(64)   NOT NULL,
  language      varchar(10)   NOT NULL,
  channel_id    varchar(20)   NOT NULL,
  game_id       varchar(20)   NOT NULL,
  start_time    timestamp     NOT NULL,
  end_time      timestamp     NOT NULL,
  UNIQUE(event_node_id, language),
  UNIQUE(event_node_id, channel_id)
);

CREATE INDEX broadcasts_language_idx ON broadcasts (language);
CREATE INDEX broadcasts_event_node_id_idx ON broadcasts (event_node_id);
CREATE INDEX broadcasts_channel_id_idx ON broadcasts (channel_id);
CREATE INDEX broadcasts_game_id_idx ON broadcasts (game_id);
CREATE INDEX broadcasts_start_time_idx ON broadcasts (start_time);
CREATE INDEX broadcasts_end_time_idx ON broadcasts (end_time);

CREATE TABLE IF NOT EXISTS broadcast_tags (
  broadcast_id  varchar(64)   NOT NULL,
  tag_name      varchar(255)  NOT NULL
);
