package models

import (
	"time"

	"code.justin.tv/twitch-events/gea/internal/db"
	"code.justin.tv/twitch-events/gea/internal/images"
)

type V1CreateEventParams struct {
	OwnerID  string  `json:"owner_id"`
	Type     string  `json:"type"`
	ParentID *string `json:"parent_id"`

	StartTime *time.Time `json:"start_time"`
	EndTime   *time.Time `json:"end_time"`

	CoverImageID *images.ImageID `json:"image_id"`
	Language     *string         `json:"language"`
	Title        *string         `json:"title"`
	Description  *string         `json:"description"`
	ChannelID    *string         `json:"channel_id"`
	GameID       *string         `json:"game_id"`
	TimeZoneID   *string         `json:"time_zone_id"`

	// Premiere fields
	PremiereID *string `json:"premiere_id"`
}

type V1UpdateEventParams struct {
	ID       string  `json:"id"`
	OwnerID  *string `json:"owner_id"`
	Type     *string `json:"type"`
	ParentID *string `json:"parent_id"`

	StartTime *time.Time `json:"start_time"`
	EndTime   *time.Time `json:"end_time"`

	CoverImageID *images.ImageID `json:"image_id"`
	Language     *string         `json:"language"`
	Title        *string         `json:"title"`
	Description  *string         `json:"description"`
	ChannelID    *string         `json:"channel_id"`
	GameID       *string         `json:"game_id"`
	TimeZoneID   *string         `json:"time_zone_id"`

	// Premiere fields
	PremiereID *string `json:"premiere_id"`
}

type V1DeleteEventParams struct {
	ID string `json:"id"`
}

func (params *V1UpdateEventParams) MergeWithDB(dbEvent *db.Event, dbAttributes map[string]string) *V1UpdateEventParams {
	params.ID = dbEvent.ID
	if params.ParentID == nil {
		params.ParentID = dbEvent.ParentID
	}
	if params.OwnerID == nil {
		params.OwnerID = &dbEvent.OwnerID
	}
	if params.Type == nil {
		params.Type = &dbEvent.Type
	}
	if params.StartTime == nil {
		params.StartTime = dbEvent.StartTime
	}
	if params.EndTime == nil {
		params.EndTime = dbEvent.EndTime
	}
	if params.CoverImageID == nil {
		params.CoverImageID = dbEvent.CoverImageID
	}
	if params.Language == nil {
		params.Language = dbEvent.Language
	}
	if params.Title == nil {
		params.Title = dbEvent.Title
	}
	if params.Description == nil {
		params.Description = dbEvent.Description
	}
	if params.ChannelID == nil {
		params.ChannelID = dbEvent.ChannelID
	}
	if params.GameID == nil {
		params.GameID = dbEvent.GameID
	}
	if params.TimeZoneID == nil {
		params.TimeZoneID = dbEvent.TimeZoneID
	}

	if params.PremiereID == nil {
		if premiereID, ok := dbAttributes["premiere_id"]; ok {
			params.PremiereID = &premiereID
		}
	}

	return params
}

type V1EventIDs struct {
	EventIDs []string `json:"event_ids"`
	Cursor   string   `json:"cursor"`
}

type V1EventIDsFromFilterOpts struct {
	Items           []V1EventIDItem `json:"items,omitempty"`
	HasNextPage     bool            `json:"has_next_page,omitempty"`
	HasPreviousPage bool            `json:"has_previous_page,omitempty"`

	EventIDs      []string `json:"event_ids"`
	LastIDCursor  string   `json:"cursor"`
	FirstIDCursor string   `json:"first_item_cursor,omitempty"`
}

type V1EventIDItem struct {
	EventID string `json:"event_id,omitempty"`
	Cursor  string `json:"cursor,omitempty"`
}

type V1EventStats struct {
	EventID     string `json:"event_id"`
	FollowCount int    `json:"follow_count"`
}

type V1EventStatsResponse struct {
	Items []*V1EventStats `json:"items"`
}
