package models

// Server-side tracking events

// ServerFollowTracking fires whenever a user follows or unfollows an event.
type ServerFollowTracking struct {
	Action      string `json:"action"`
	UserID      int64  `json:"user_id"`
	EventID     string `json:"event_id"`
	FollowCount int64  `json:"follow_count"`
}

// ServerEventTracking fires whenever a user creates, updates, or deletes an event.
type ServerEventTracking struct {
	Action        string `json:"action"`
	UserID        int64  `json:"user_id,omitempty"`
	EventID       string `json:"event_id"`
	EventType     string `json:"event_type"`
	ParentEventID string `json:"parent_event_id"`
	CreatedAt     int64  `json:"created_at_timestamp"`
	UpdatedAt     int64  `json:"updated_at_timestamp"`
	StartTime     *int64 `json:"event_start_timestamp,omitempty"`
	EndTime       *int64 `json:"event_end_timestamp,omitempty"`
	TimeZoneID    string `json:"timezone"`
	ChannelID     string `json:"channel_id"`
	Title         string `json:"title"`
	Description   string `json:"description"`
	GameID        int64  `json:"game_id,omitempty"`
	CoverImageID  string `json:"cover_image_uuid"`
}
