# Poll-Endpoint #

`poll-endpoint` sends a POST request to a given endpoint.  It is meant to be run periodically to invoke an endpoint 
on a schedule.  

## Periodic Operations ##

The Events infrastructure implements periodic operations using 
  * an endpoint on Gea that starts the operation
  * A [scheduled ECS task](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/scheduled_tasks.html)
    that runs on a cron-like schedule, and invokes the Gea endpoint
    
The scheduled ECS task runs poll-endpoint.  

## Docker Image Usage ##

Required Environment Variables:

  * ENDPOINT: This should be set to the URL that the POST request should be sent to.
    E.g. `ENDPOINT=http://events-production.internal.justin.tv/v1/create_channel_event_updates`

## Deployment ##

Build and push a new image to Twitch's Docker registry.

  * Run `make build_poller_image`.  This:
    * Builds `poller_Dockerfile` which compiles `poll-endpoint` and creates a Docker image.
    * Tags the image with the git SHA, and pushes it to Twitch's docker registry.
  
Update the ECS task to use the new image:

  * Update `image` in the poller Terraform module.  (`terraform\modules\poller\main.tf`)
  * Run `terraform apply` in the Gea root modules.
  