package main

import (
	"fmt"
	"io/ioutil"
	"net/http"
	"os"

	"code.justin.tv/feeds/errors"
)

func pingEndpoint() error {
	endpoint := os.Getenv("ENDPOINT")
	if endpoint == "" {
		return errors.New("ENDPOINT environment variable was empty")
	}

	var httpClient http.Client
	resp, err := httpClient.Post(endpoint, "", nil)
	if err != nil {
		return err
	}

	defer func() {
		retErr := resp.Body.Close()
		if retErr != nil {
			fmt.Println(fmt.Sprintf("%+v", retErr))
		}
	}()
	if resp.StatusCode != http.StatusOK {
		return extractError(endpoint, resp)
	}

	return nil
}

func extractError(endpoint string, r *http.Response) error {
	body, err := ioutil.ReadAll(r.Body)
	if err != nil {
		return errors.Wrapf(
			err,
			"sending a POST to \"%s\" returned an unexpected status code %d, and reading the response body failed",
			endpoint,
			r.StatusCode)
	}

	return errors.Errorf(
		"sending a POST to \"%s\" returned an unexpected status code %d, and body: %s",
		endpoint,
		r.StatusCode,
		string(body))
}

func main() {
	err := pingEndpoint()
	if err != nil {
		fmt.Println(fmt.Sprintf("%+v", err))
	}
}
