package config

import (
	"encoding/json"
	"io/ioutil"
	"testing"

	. "github.com/smartystreets/goconvey/convey"
)

func TestConfig(t *testing.T) {
	Convey("Development Config", t, func() {
		byteValue, err := ioutil.ReadFile("./development.json")
		So(err, ShouldBeNil)

		var objmap map[string]string
		jsonErr := json.Unmarshal(byteValue, &objmap)
		So(jsonErr, ShouldBeNil)
	})

	Convey("Integration Config", t, func() {
		byteValue, err := ioutil.ReadFile("./integration.json")
		So(err, ShouldBeNil)

		var objmap map[string]string
		jsonErr := json.Unmarshal(byteValue, &objmap)
		So(jsonErr, ShouldBeNil)
	})

	Convey("Staging Config", t, func() {
		byteValue, err := ioutil.ReadFile("./staging.json")
		So(err, ShouldBeNil)

		var objmap map[string]string
		jsonErr := json.Unmarshal(byteValue, &objmap)
		So(jsonErr, ShouldBeNil)
	})

	Convey("Production Config", t, func() {
		byteValue, err := ioutil.ReadFile("./production.json")
		So(err, ShouldBeNil)

		var objmap map[string]string
		jsonErr := json.Unmarshal(byteValue, &objmap)
		So(jsonErr, ShouldBeNil)
	})
}
