package clock

import (
	"time"
)

// Clock is an interface that allows us to control the implementation of Now()
type Clock interface {
	NowUTC() time.Time
}

// RealClock represents what would be the global system Time
type RealClock struct{}

// NowUTC as implemented by RealClock returns time.Now().UTC()
func (r *RealClock) NowUTC() time.Time {
	return time.Now().UTC()
}
