package cursor

import (
	"testing"

	. "github.com/smartystreets/goconvey/convey"
)

func TestCursor(t *testing.T) {
	Convey("Encode() should convert a JSON serializable struct to a string", t, func() {
		c := &OffsetCursor{
			Version: 2,
			Offset:  3,
		}

		cursorStr, err := Encode(c)
		So(err, ShouldBeNil)
		So(cursorStr, ShouldNotBeEmpty)

		Convey("Decode() should be able to decode the cursor string", func() {
			decoded := OffsetCursor{}

			err := Decode(cursorStr, &decoded)
			So(err, ShouldBeNil)
			So(decoded, ShouldResemble, *c)
		})

		Convey("DecodeVersioned() should decode the cursor string and return false when the expected version matches", func() {
			decoded := OffsetCursor{}

			isWrongVersion, err := DecodeVersioned(cursorStr, c.Version, &decoded)
			So(err, ShouldBeNil)
			So(isWrongVersion, ShouldBeFalse)
			So(decoded, ShouldResemble, *c)
		})

		Convey("DecodeVersioned() should return true and an error if the version is incorrect", func() {
			decoded := OffsetCursor{}

			isWrongVersion, err := DecodeVersioned(cursorStr, c.Version+1, &decoded)
			So(err, ShouldNotBeNil)
			So(isWrongVersion, ShouldBeTrue)
		})
	})
}
