package db

// queryParams facilitates working with lists of values that need to be substituted into SQL queries.
type queryParams struct {
	params []interface{}
}

func newQueryParams() *queryParams {
	return &queryParams{
		params: make([]interface{}, 0),
	}
}

func (q *queryParams) add(param ...interface{}) {
	q.params = append(q.params, param...)
}

func (q *queryParams) nextPlaceholder() int {
	return len(q.params) + 1
}
