package hallpass

import (
	hallpass "code.justin.tv/cb/hallpass/client/hallpass"
	"code.justin.tv/foundation/twitchclient"
	"github.com/pkg/errors"

	"context"
)

const (
	defaultTimingXactName = "hallpass"
	defaultStatPrefix     = "hallpass."
	defaultStatSampleRate = 1.0
)

type Client interface {
	IsEditor(ctx context.Context, userID, channelID string) (bool, error)
}

type hallpassImpl struct {
	Client hallpass.Client
}

func NewClient(conf twitchclient.ClientConf) (Client, error) {
	if conf.TimingXactName == "" {
		conf.TimingXactName = defaultTimingXactName
	}
	hallpassClient, err := hallpass.NewClient(conf)
	if err != nil {
		return nil, err
	}
	return &hallpassImpl{Client: hallpassClient}, nil
}

func (c *hallpassImpl) IsEditor(ctx context.Context, userID, channelID string) (bool, error) {
	combinedReqOpts := twitchclient.MergeReqOpts(nil, twitchclient.ReqOpts{
		StatName:       defaultStatPrefix + "is_editor",
		StatSampleRate: defaultStatSampleRate,
	})

	resp, err := c.Client.GetV1IsEditor(ctx, channelID, userID, &combinedReqOpts)
	if err != nil {
		return false, errors.Wrap(err, "Unable to get isEditor")
	}

	return resp.IsEditor, nil
}
