package recipient

import (
	"context"

	"code.justin.tv/twitch-events/gea/internal/types"
)

type PremiereRecipientLoader struct {
	BaseRecipientLoader
}

var _ TypedRecipientLoader = &PremiereRecipientLoader{}

func (s *PremiereRecipientLoader) Handles(eventType string) bool {
	return eventType == types.EventTypePremiere
}

func (s *PremiereRecipientLoader) LoadRecipients(ctx context.Context, premiereEvent types.TypedEvent) ([]string, error) {
	return s.loadEventFollowers(ctx, premiereEvent.GetID())
}
