package recipient

import (
	"context"

	"code.justin.tv/twitch-events/gea/internal/types"
)

type SingleRecipientLoader struct {
	BaseRecipientLoader
}

var _ TypedRecipientLoader = &SingleRecipientLoader{}

func (s *SingleRecipientLoader) Handles(eventType string) bool {
	return eventType == types.EventTypeSingle
}

func (s *SingleRecipientLoader) LoadRecipients(ctx context.Context, singleEvent types.TypedEvent) ([]string, error) {
	return s.loadEventFollowers(ctx, singleEvent.GetID())
}
