package images

import (
	"fmt"

	"code.justin.tv/feeds/distconf"
	"code.justin.tv/feeds/log"
)

type ImageURLConfig struct {
	geaTemplate     *distconf.Str
	oracleTemplate  *distconf.Str
	defaultTemplate *distconf.Str
}

func (c *ImageURLConfig) Load(dconf *distconf.Distconf) error {
	c.geaTemplate = dconf.Str("gea.images.gea_template", "/gea/%s")
	c.oracleTemplate = dconf.Str("gea.images.oracle_template", "/oracle/%s")
	c.defaultTemplate = dconf.Str("gea.images.default_template", "/default/%s")

	return nil
}

type ImageURLClient struct {
	Config ImageURLConfig
	Log    log.Logger
}

func (i *ImageURLClient) GetImageURL(imageID *ImageID) string {
	if imageID == nil {
		return ""
	}

	var urlTemplate string
	switch imageID.Type {
	case "gea":
		urlTemplate = i.Config.geaTemplate.Get()
	case "oracle":
		urlTemplate = i.Config.oracleTemplate.Get()
	case "default":
		urlTemplate = i.Config.defaultTemplate.Get()
	}
	return fmt.Sprintf(urlTemplate, imageID.ID)
}
