package jax

import (
	"code.justin.tv/foundation/twitchclient"
	jaxclient "code.justin.tv/web/jax/client"

	"code.justin.tv/feeds/errors"
	"golang.org/x/net/context"
)

// Client contain the methods on jax.Client that Scheduler uses.
type Client interface {
	// Returns a list of streams from a list of channel ids.
	// Accepts an array of options to filter out streams.
	GetStreamsByChannelIDs(ctx context.Context, ids []string, opts *jaxclient.StreamsOptions, reqOpts *twitchclient.ReqOpts) (*jaxclient.Streams, error)
}

// The errors returned by the Jax client provided in code.justin.tv/web/jax do not have stack traces.
// ClientWithWrappedErrors wraps a Jax client, and adds a stack trace to errors that the  underlying client
// returns.
type ClientWithWrappedErrors struct {
	InnerClient Client
}

func (j *ClientWithWrappedErrors) GetStreamsByChannelIDs(ctx context.Context, ids []string, opts *jaxclient.StreamsOptions, reqOpts *twitchclient.ReqOpts) (*jaxclient.Streams, error) {
	streams, err := j.InnerClient.GetStreamsByChannelIDs(ctx, ids, opts, reqOpts)
	if err != nil {
		return nil, errors.New(err.Error())
	}
	return streams, nil
}
