package testutils

import (
	"context"

	"code.justin.tv/twitch-events/gea/internal/auth"
)

// AllAuthenticatedAdminList is meant to allow tests to bypass authorization.  AllAuthenticatedAdminList treats
// all users as being event admins.
type AllAuthenticatedAdminList struct{}

var _ auth.AdminList = &AllAuthenticatedAdminList{}

func (d *AllAuthenticatedAdminList) IsEventsAdmin(ctx context.Context, userID string) bool {
	return userID != ""
}

// EmptyAdminList is meant to allow tests to verify authorization logic.  It always returns that users are not
// admin, allowing tests to check the other logic that gates an operation.
type EmptyAdminList struct{}

var _ auth.AdminList = &EmptyAdminList{}

func (d *EmptyAdminList) IsEventsAdmin(ctx context.Context, userID string) bool {
	return false
}
