package assertions

import (
	"fmt"
	"net/url"
)

func ShouldBeFullHTTPURL(actual interface{}, expected ...interface{}) string {
	str, ok := actual.(string)
	if !ok {
		return "Expected that actual would be a URL of type string"
	}

	u, err := url.ParseRequestURI(str)
	if err != nil {
		return fmt.Sprintf("Expected that string, \"%s\", would be valid URL (but was not!) error: %v", str, err)
	}

	if !u.IsAbs() {
		return fmt.Sprintf("Expected that string, \"%s\", would be an absolute URL (but was not!)", str)
	}

	return ""
}
