package testutils

import (
	"context"
	"sync"

	"code.justin.tv/twitch-events/gea/internal/auth"
)

// NewStubAuthUsersClient is meant to allow tests to verify authorization logic.
func NewStubAuthUsersClient(isSuspended, isTwitchAdmin bool) *StubAuthUsersClient {
	return &StubAuthUsersClient{
		isSuspended:   isSuspended,
		isTwitchAdmin: isTwitchAdmin,
	}
}

type StubAuthUsersClient struct {
	mutex         sync.Mutex
	isSuspended   bool
	isTwitchAdmin bool
}

var _ auth.Client = &StubAuthUsersClient{}

func (c *StubAuthUsersClient) GetUserAuthProperties(ctx context.Context, userID string) *auth.UserAuthProperties {
	c.mutex.Lock()
	userAuthProperties := &auth.UserAuthProperties{
		IsSuspended:   c.isSuspended,
		IsTwitchAdmin: c.isTwitchAdmin,
	}
	c.mutex.Unlock()

	return userAuthProperties
}

func (c *StubAuthUsersClient) SetIsSuspended(isSuspended bool) {
	c.mutex.Lock()
	c.isSuspended = isSuspended
	c.mutex.Unlock()
}

func (c *StubAuthUsersClient) SetIsTwitchAdmin(isTwitchAdmin bool) {
	c.mutex.Lock()
	c.isTwitchAdmin = isTwitchAdmin
	c.mutex.Unlock()
}
