package types

import (
	"fmt"
	"time"
)

// Event Metadata constants
const (
	OGImageWidth       = "1200"
	OGImageHeight      = "630"
	twitterImageWidth  = "1120"
	twitterImageHeight = "600"
	openGraphType      = "article"
	twitterCard        = "summary_large_image"
)

func formatTimeRange(startTime time.Time, endTime time.Time, timeZone *time.Location) string {
	start := startTime.In(timeZone)
	end := endTime.In(timeZone)

	// Description should be in the form: 'Mar 21 • 10:00 AM - Apr 21 • 10:00 AM PDT'
	// or: 'Mar 21 • 10:00 AM - 11:00 AM PDT'
	description := ""
	if start.Year() == end.Year() && start.Month() == end.Month() && start.Day() == end.Day() {
		description = fmt.Sprintf("%s - %s", start.Format("Jan 2 • 3:04 PM"), end.Format("3:04 PM MST"))
	} else {
		formattedStart := start.Format("Jan 2 • 3:04 PM")
		formattedEnd := end.Format("Jan 2 • 3:04 PM MST")
		description = fmt.Sprintf("%s - %s", formattedStart, formattedEnd)
	}

	return description
}
