package geaclient

import (
	"context"

	"code.justin.tv/foundation/twitchclient"
)

type ImageUploadReservation struct {
	UploadURL string `json:"upload_url"`
	UploadID  string `json:"upload_id"`
}

type ImageUploadConfirmation struct {
	UploadID string `json:"upload_id"`
}

func (c *ClientImpl) ReserveImageUpload(ctx context.Context, userID string, reqOpts *twitchclient.ReqOpts) (*ImageUploadReservation, error) {
	path := "/v1/reserve_image_upload?user_id=" + userID

	reservation := &ImageUploadReservation{}
	err := c.http(ctx, "reserve_iamge_upload", "POST", path, nil, nil, reqOpts, reservation)
	if err != nil {
		return nil, err
	}

	return reservation, nil
}

type ImagePayload struct {
	Base64EncodedImage string `json:"event_cover_image"`
}

/** WARNING: THIS IS LAUNCHING DEPRECATED, PLEASE DO NOT USE THIS **/
func (c *ClientImpl) UploadBase64Image(ctx context.Context, userID string, imagePayload *ImagePayload, reqOpts *twitchclient.ReqOpts) (*ImageUploadConfirmation, error) {
	path := "/v1/legacy_image_upload?user_id=" + userID

	confirmation := &ImageUploadConfirmation{}
	err := c.http(ctx, "legacy_image_upload", "POST", path, nil, imagePayload, reqOpts, confirmation)
	if err != nil {
		return nil, err
	}

	return confirmation, nil
}
