package geaclient

import (
	"context"
	"fmt"
	"net/url"
	"time"

	"code.justin.tv/foundation/twitchclient"
)

type Localization struct {
	EventID  string `json:"event_id"`
	Language string `json:"language"`

	CreatedAt time.Time `json:"created_at"`
	DeletedAt time.Time `json:"deleted_at"`

	Title       *string `json:"title"`
	Description *string `json:"description"`
	ChannelID   *string `json:"channel_id"`
}

type AddLocalizationParams struct {
	EventID  string `json:"event_id"`
	Language string `json:"language"`

	Title       *string `json:"title,omitempty"`
	Description *string `json:"description,omitempty"`
	ChannelID   *string `json:"channel_id,omitempty"`
}

func (c *ClientImpl) AddLocalization(ctx context.Context, params AddLocalizationParams, userID string, reqOpts *twitchclient.ReqOpts) (*Localization, error) {
	path := fmt.Sprintf("/v1/add_localization?user_id=%s", url.QueryEscape(userID))
	var response Localization
	err := c.http(ctx, "add_localization", "POST", path, nil, params, reqOpts, &response)
	if err != nil {
		return nil, err
	}
	return &response, nil
}

type UpdateLocalizationParams struct {
	EventID  string `json:"event_id"`
	Language string `json:"language"`

	Title       *string `json:"title,omitempty"`
	Description *string `json:"description,omitempty"`
	ChannelID   *string `json:"channel_id,omitempty"`
}

func (c *ClientImpl) UpdateLocalization(ctx context.Context, params UpdateLocalizationParams, userID string, reqOpts *twitchclient.ReqOpts) (*Localization, error) {
	path := fmt.Sprintf("/v1/update_localization?user_id=%s", url.QueryEscape(userID))
	var response Localization
	err := c.http(ctx, "update_localization", "POST", path, nil, params, reqOpts, &response)
	if err != nil {
		return nil, err
	}
	return &response, nil
}

type removeLocalizationParams struct {
	EventID  string `json:"event_id"`
	Language string `json:"language"`
}

func (c *ClientImpl) RemoveLocalization(ctx context.Context, eventID string, language string, userID string, reqOpts *twitchclient.ReqOpts) (*Localization, error) {
	path := fmt.Sprintf("/v1/remove_localization?user_id=%s", url.QueryEscape(userID))
	params := removeLocalizationParams{
		EventID:  eventID,
		Language: language,
	}
	var response Localization
	err := c.http(ctx, "remove_localization", "POST", path, nil, params, reqOpts, &response)
	if err != nil {
		return nil, err
	}
	return &response, nil
}
