terraform {
  backend "s3" {
    bucket  = "twitch-feed-aws"
    key     = "tfstate/events/core/terraform/canary"
    region  = "us-west-2"
    profile = "twitch-feed-aws"
  }
}

locals {
  instance_type = "c4.4xlarge"
}

module "twitch_core" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/twitch/terraform//core?ref=622157fac36fb40cedcdf9e0b40ca6e5fa1b9917"

  # This should just be team and name
  team   = "${local.team}"
  region = "${local.region}"

  # This can come from the staging provider
  environment             = "${local.environment}"
  container_log_retention = "7"
  xray_role               = "arn:aws:iam::465369119046:role/foundation-xray-role"
}

module "ecsasg" {
  source           = "git::git+ssh://git@git-aws.internal.justin.tv/twitch/terraform//ecsasg?ref=622157fac36fb40cedcdf9e0b40ca6e5fa1b9917"
  cluster_name     = "${module.twitch_core.common_cluster_name}"
  account          = "${local.account}"
  environment      = "${local.environment}"
  min_size         = "2"
  desired_capacity = "3"
  max_size         = "5"
  team             = "${local.team}"
  owner            = "${local.owner}"
  name             = "common"
  instance_type    = "${local.instance_type}"

  # (us-west-2 amzn-ami-2017.09.f-amazon-ecs-optimized)
  ami = "ami-c9c87cb1"

  container_instance_profile_id = "${module.twitch_core.container_instance_profile_id}"
}

module "events_core" {
  source = "../../../modules/core"

  team        = "${local.team}"
  environment = "${local.environment}"

  sandstorm_role_arn = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/events-canary"

  # TODO: Get the deployment IAM role name from the Twitch Core module, sinc it created the role.
  # We can't currently get it from the Twitch Core module because v622157 outputs the ARN, instead of the name.
  build_deployment_role_name = "events-${local.environment}-build-deployment"
}

output container_loggroup {
  value = "${module.twitch_core.container_loggroup}"
}

output container_loggroup_region {
  value = "${module.twitch_core.container_loggroup_region}"
}

output container_instance_profile_id {
  value = "${module.twitch_core.container_instance_profile_id}"
}

output container_iam_role {
  value = "${module.twitch_core.container_iam_role}"
}

output service_iam_role {
  value = "${module.twitch_core.service_iam_role}"
}

output task_autoscale_iam_role {
  value = "${module.twitch_core.task_autoscale_iam_role}"
}

output "statsite_task_family" {
  value = "${module.twitch_core.statsite_task_family}"
}

output "xray_task_family" {
  value = "${module.twitch_core.xray_task_family}"
}

output "xray_task_role" {
  value = "${module.twitch_core.xray_task_role}"
}

output common_cluster_name {
  value = "${module.twitch_core.common_cluster_name}"
}

output common_cluster_id {
  value = "${module.twitch_core.common_cluster_id}"
}

output build_role {
  value = "${module.twitch_core.build_role}"
}

output build_user {
  value = "${module.twitch_core.build_user}"
}

output jenkins_build_secret {
  value = "aws-${local.team}-${local.environment}"
}

output sandstorm_policy_arn {
  value = "${module.events_core.sandstorm_policy_arn}"
}
