terraform {
  backend "s3" {
    bucket  = "twitch-feed-dev"
    key     = "tfstate/events/dynamodb/terraform/integration"
    region  = "us-west-2"
    profile = "twitch-feed-dev"
  }
}

module "dynamodb" {
  source = "../../../modules/dynamodb"

  # Environment
  team        = "${local.team}"
  account     = "${local.account}"
  environment = "${local.environment}"
  name        = "gea"

  # Capacity properties
  event_follows_read_capacity  = "300"
  event_follows_write_capacity = "100"

  event_notifications_read_capacity  = "500"
  event_notifications_write_capacity = "500"
}
