terraform {
  backend "s3" {
    bucket  = "twitch-feed-dev"
    key     = "tfstate/events/elasticache/terraform/integration"
    region  = "us-west-2"
    profile = "twitch-feed-dev"
  }
}

module "elasticache" {
  source = "../../../modules/elasticache"

  # Environment
  account     = "${local.account}"
  region      = "${local.region}"
  team        = "${local.team}"
  environment = "${local.environment}"
  owner       = "${local.owner}"
  name        = "gea"

  # Capacity properties
  elasticache_node_type = "cache.m3.medium"
  elasticache_node_count = "2"
}
