terraform {
  backend "s3" {
    bucket  = "twitch-feed-dev"
    key     = "tfstate/events/uploads/terraform/integration"
    region  = "us-west-2"
    profile = "twitch-feed-dev"
  }
}

provider "aws" {
  region  = "us-west-2"
  profile = "twitch-feed-dev"
}

locals {
  owner       = "events-core@justin.tv"
  environment = "integration"
  team        = "events"

  upload_service_arns = [
    # Role of the deprecated service in twitch-web-dev
    "arn:aws:iam::465369119046:role/staging-web-upload-service",

    # Role of the new service in twitch-asset-uploads-dev
    "arn:aws:iam::995367761609:role/staging-upload-service",
  ]
}

module "uploads" {
  source = "../../../modules/uploads"

  name                = "gea"
  owner               = "${local.owner}"
  team                = "${local.team}"
  environment         = "${local.environment}"
  upload_service_arns = "${local.upload_service_arns}"
}

module "upload_bucket_policy_without_cdn" {
  source = "../../../modules/upload_bucket_policy_without_cdn"

  upload_s3_bucket_id  = "${module.uploads.uploads_s3_bucket_id}"
  upload_s3_bucket_arn = "${module.uploads.uploads_s3_bucket_arn}"
  upload_service_arns  = "${local.upload_service_arns}"
  reader_service_arns  = ["arn:aws:iam::724951484461:role/events-gea-integration"]
}
