terraform {
  backend "s3" {
    bucket  = "twitch-feed-aws"
    key     = "tfstate/events/core/terraform/production"
    region  = "us-west-2"
    profile = "twitch-feed-aws"
  }
}

locals {
  instance_type = "c4.4xlarge"
}

module "twitch_core" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/twitch/terraform//core?ref=622157fac36fb40cedcdf9e0b40ca6e5fa1b9917"

  # This should just be team and name
  team   = "${var.team}"
  region = "${var.region}"

  # This can come from the staging provider
  environment             = "${var.environment}"
  container_log_retention = "7"
  xray_role               = "arn:aws:iam::465369119046:role/foundation-xray-role"
}

module "ecsasg" {
  source           = "git::git+ssh://git@git-aws.internal.justin.tv/twitch/terraform//ecsasg?ref=622157fac36fb40cedcdf9e0b40ca6e5fa1b9917"
  cluster_name     = "${module.twitch_core.common_cluster_name}"
  account          = "${var.account}"
  environment      = "${var.environment}"
  min_size         = "4"
  desired_capacity = "4"
  max_size         = "10"
  team             = "${var.team}"
  owner            = "${var.owner}"
  name             = "common"
  instance_type    = "${local.instance_type}"

  # (us-west-2 amzn-ami-2017.09.f-amazon-ecs-optimized)
  ami = "ami-c9c87cb1"

  container_instance_profile_id = "${module.twitch_core.container_instance_profile_id}"
}

module "events_core" {
  source = "../../../modules/core"

  team        = "${var.team}"
  environment = "${var.environment}"

  sandstorm_role_arn = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/events-${var.environment}"

  # TODO: Get the deployment IAM role name from the Twitch Core module, sinc it created the role.
  # We can't currently get it from the Twitch Core module because v622157 outputs the ARN, instead of the name.
  build_deployment_role_name = "events-${var.environment}-build-deployment"
}

output container_loggroup {
  value = "${module.twitch_core.container_loggroup}"
}

output container_loggroup_region {
  value = "${module.twitch_core.container_loggroup_region}"
}

output container_instance_profile_id {
  value = "${module.twitch_core.container_instance_profile_id}"
}

output container_iam_role {
  value = "${module.twitch_core.container_iam_role}"
}

output service_iam_role {
  value = "${module.twitch_core.service_iam_role}"
}

output task_autoscale_iam_role {
  value = "${module.twitch_core.task_autoscale_iam_role}"
}

output "statsite_task_family" {
  value = "${module.twitch_core.statsite_task_family}"
}

output "xray_task_family" {
  value = "${module.twitch_core.xray_task_family}"
}

output "xray_task_role" {
  value = "${module.twitch_core.xray_task_role}"
}

output common_cluster_name {
  value = "${module.twitch_core.common_cluster_name}"
}

output common_cluster_id {
  value = "${module.twitch_core.common_cluster_id}"
}

output build_role {
  value = "${module.twitch_core.build_role}"
}

output build_user {
  value = "${module.twitch_core.build_user}"
}

output jenkins_build_secret {
  value = "aws-${var.team}-${var.environment}"
}

output sandstorm_policy_arn {
  value = "${module.events_core.sandstorm_policy_arn}"
}
