terraform {
  backend "s3" {
    bucket  = "twitch-feed-aws"
    key     = "tfstate/events/dynamodb/terraform/production"
    region  = "us-west-2"
    profile = "twitch-feed-aws"
  }
}

module "dynamodb" {
  source = "../../../modules/dynamodb"

  # Environment
  team        = "${var.team}"
  account     = "${var.account}"
  environment = "${var.environment}"
  name        = "gea"

  # Capacity properties

  # 9/14/17 - 1500: Starting this at half of what a single partition can handle
  event_follows_read_capacity = "1500"
  # 9/14/17 - 500: Starting this at half of what a single partition can handle
  event_follows_write_capacity = "500"
  # 9/14/17 - 1500: Starting this at half of what a single partition can handle
  event_notifications_read_capacity = "1500"
  # 9/14/17 - 500: Starting this at half of what a single partition can handle
  event_notifications_write_capacity = "500"
}
