terraform {
  backend "s3" {
    bucket  = "twitch-feed-aws"
    key     = "tfstate/events/elasticache/terraform/production"
    region  = "us-west-2"
    profile = "twitch-feed-aws"
  }
}

module "elasticache" {
  source = "../../../modules/elasticache"

  # Environment
  account     = "${var.account}"
  region      = "${var.region}"
  team        = "${var.team}"
  environment = "${var.environment}"
  owner       = "${var.owner}"
  name        = "gea"

  # Capacity properties
  elasticache_node_type = "cache.r3.2xlarge"
  elasticache_node_count = "3"
}
