terraform {
  backend "s3" {
    bucket  = "twitch-feed-aws"
    key     = "tfstate/events/uploads/terraform/production"
    region  = "us-west-2"
    profile = "twitch-feed-aws"
  }
}

provider "aws" {
  region  = "us-west-2"
  profile = "twitch-feed-aws"
}

locals {
  owner       = "events-core@justin.tv"
  environment = "production"
  team        = "events"

  upload_service_arns = [
    # Role of the deprecated service in twitch-web-aws
    "arn:aws:iam::641044725657:role/prod-web-upload-service",

    # Role of the new service in twitch-asset-uploads-prod
    "arn:aws:iam::435569175256:role/prod-upload-service",
  ]
}

module "uploads" {
  source = "../../../modules/uploads"

  name                = "gea"
  owner               = "${local.owner}"
  team                = "${local.team}"
  environment         = "${local.environment}"
  upload_service_arns = "${local.upload_service_arns}"
}

module "upload_bucket_policy_with_cdn" {
  source = "../../../modules/upload_bucket_policy_with_cdn"

  upload_s3_bucket_id  = "${module.uploads.uploads_s3_bucket_id}"
  upload_s3_bucket_arn = "${module.uploads.uploads_s3_bucket_arn}"
  upload_service_arns  = "${local.upload_service_arns}"

  reader_service_arns = [
    "arn:aws:iam::914569885343:role/events-gea-canary",
    "arn:aws:iam::914569885343:role/events-gea-production",
  ]
}

module "upload_service_peering_connection" {
  source = "../../../modules/vpc_peer_accepter"

  sender_aws_account_alias  = "twitch-asset-uploads-prod"
  sender_cidr_block         = "10.205.204.0/22"
  vpc_id                    = "vpc-29b8fe4d"
  vpc_peering_connection_id = "pcx-069e1408a3b216356"
}
