terraform {
  backend "s3" {
    bucket  = "twitch-feed-dev"
    key     = "tfstate/events/elasticache/terraform/staging"
    region  = "us-west-2"
    profile = "twitch-feed-dev"
  }
}

module "elasticache" {
  source = "../../../modules/elasticache"

  # Environment
  account     = "${var.account}"
  region      = "${var.region}"
  team        = "${var.team}"
  environment = "${var.environment}"
  owner       = "${var.owner}"
  name        = "gea"

  # Capacity properties
  elasticache_node_type = "cache.m3.medium"
  elasticache_node_count = "2"
}
